<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Trade extends Model
{
    protected $fillable = [
        'user_id',
        'pair',
        'amount',
        'type',
        'entry_price',
        'close_price',
        'profit_percentage',
        'profit_amount',
        'duration',
        'status',
        'result',
        'completed_at',
    	'expected_result'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'entry_price' => 'decimal:8',
        'close_price' => 'decimal:8',
        'profit_percentage' => 'decimal:2',
        'profit_amount' => 'decimal:2',
        'completed_at' => 'datetime'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    
    public function copiedTrade()
    {
    return $this->hasOne(CopiedTrade::class, 'copied_trade_id');
    }

}