@props(['id' => null, 'maxWidth' => null])

@php
$maxWidth = [
    'sm' => 'sm:max-w-sm',
    'md' => 'sm:max-w-md',
    'lg' => 'sm:max-w-lg',
    'xl' => 'sm:max-w-xl',
    '2xl' => 'sm:max-w-2xl',
][$maxWidth ?? 'lg'];
@endphp

<x-modal :id="$id" :maxWidth="$maxWidth" {{ $attributes }}>
    <div class="relative transform overflow-hidden rounded-2xl bg-theme-secondary text-left shadow-xl transition-all">
        {{-- Header/Title Section --}}
        <div class="bg-theme-tertiary px-6 py-4">
            <h3 class="text-lg font-medium text-gray-200">
                {{ $title }}
            </h3>
        </div>

        {{-- Content Section --}}
        <div class="px-6 py-4">
            <p class="text-sm text-gray-400">
                {{ $content }}
            </p>
            
            {{-- Slot for additional content --}}
            <div class="mt-4">
                {{ $slot ?? '' }}
            </div>
        </div>

        {{-- Footer Section --}}
        <div class="bg-theme-tertiary px-6 py-4 flex justify-end gap-3">
            {{ $footer }}
        </div>
    </div>
</x-modal>





