@php
    $themeColors = config('theme-colors', [
        'primary' => [
            'main' => 'var(--color-primary)',
            'light' => '#3B82F6', 
            'dark' => '#1D4ED8',
            'hover' => '#1E40AF'
        ],
        'background' => [
            'primary' => '#0A0714',
            'secondary' => 'var(--color-secondary)',
            'tertiary' => 'var(--color-tertiary)',
            'quaternary' => '#2A243B'
        ],
        'text' => [
            'primary' => '#F8FAFC',
            'secondary' => '#E2E8F0',
            'muted' => '#94A3B8',
            'disabled' => '#64748B'
        ],
        'border' => [
            'primary' => '#334155',
            'secondary' => '#475569',
            'muted' => '#64748B'
        ],
        'status' => [
            'success' => '#10B981',
            'warning' => '#F59E0B',
            'error' => '#EF4444',
            'info' => '#3B82F6'
        ]
    ]);
@endphp

<style id="dynamic-theme-colors">
:root {
    /* Primary Colors */
    --color-primary: {{ $themeColors['primary']['main'] }};
    --color-primary-light: {{ $themeColors['primary']['light'] }};
    --color-primary-dark: {{ $themeColors['primary']['dark'] }};
    --color-primary-hover: {{ $themeColors['primary']['hover'] }};
    
    /* Background Colors */
    --color-background: {{ $themeColors['background']['primary'] }};
    --color-background-secondary: {{ $themeColors['background']['secondary'] }};
    --color-background-tertiary: {{ $themeColors['background']['tertiary'] }};
    --color-background-quaternary: {{ $themeColors['background']['quaternary'] }};
    
    /* Text Colors */
    --color-text-primary: {{ $themeColors['text']['primary'] }};
    --color-text-secondary: {{ $themeColors['text']['secondary'] }};
    --color-text-muted: {{ $themeColors['text']['muted'] }};
    --color-text-disabled: {{ $themeColors['text']['disabled'] }};
    
    /* Border Colors */
    --color-border-primary: {{ $themeColors['border']['primary'] }};
    --color-border-secondary: {{ $themeColors['border']['secondary'] }};
    --color-border-muted: {{ $themeColors['border']['muted'] }};
    
    /* Status Colors */
    --color-success: {{ $themeColors['status']['success'] }};
    --color-warning: {{ $themeColors['status']['warning'] }};
    --color-error: {{ $themeColors['status']['error'] }};
    --color-info: {{ $themeColors['status']['info'] }};
}

/* CDN Tailwind Compatible Classes */
.bg-theme-primary { background-color: var(--color-primary) !important; }
.bg-theme-primary-light { background-color: var(--color-primary-light) !important; }
.bg-theme-primary-dark { background-color: var(--color-primary-dark) !important; }
.bg-theme-secondary { background-color: var(--color-background-secondary) !important; }
.bg-theme-tertiary { background-color: var(--color-background-tertiary) !important; }

.text-theme-primary { color: var(--color-primary) !important; }
.text-theme-primary-dark { color: var(--color-primary-dark) !important; }
.text-theme-text-primary { color: var(--color-text-primary) !important; }
.text-theme-text-secondary { color: var(--color-text-secondary) !important; }
.text-theme-text-muted { color: var(--color-text-muted) !important; }

.border-theme-primary { border-color: var(--color-primary) !important; }
.border-theme-border-primary { border-color: var(--color-border-primary) !important; }

/* Opacity variants using rgba */
@php
    // Convert hex to rgb for opacity
    function hexToRgb($hex) {
        $hex = ltrim($hex, '#');
        if (strlen($hex) == 3) {
            $hex = $hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2];
        }
        return [
            'r' => hexdec(substr($hex, 0, 2)),
            'g' => hexdec(substr($hex, 2, 2)),
            'b' => hexdec(substr($hex, 4, 2))
        ];
    }
    $primaryRgb = hexToRgb($themeColors['primary']['main']);
@endphp

.bg-theme-primary-5 { background-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.05) !important; }
.bg-theme-primary-10 { background-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.1) !important; }
.bg-theme-primary-20 { background-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.2) !important; }
.bg-theme-primary-30 { background-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.3) !important; }
.bg-theme-primary-80 { background-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.8) !important; }

/* Hover states */
.hover\:bg-theme-primary:hover { background-color: var(--color-primary) !important; }
.hover\:bg-theme-primary-dark:hover { background-color: var(--color-primary-dark) !important; }
.hover\:text-theme-primary:hover { color: var(--color-primary) !important; }

/* Focus states */
.focus\:border-theme-primary:focus { border-color: var(--color-primary) !important; }
.focus\:ring-theme-primary:focus { 
    --tw-ring-color: rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.2) !important;
}

/* Status colors */
.bg-theme-success { background-color: var(--color-success) !important; }
.bg-theme-warning { background-color: var(--color-warning) !important; }
.bg-theme-error { background-color: var(--color-error) !important; }
.bg-theme-info { background-color: var(--color-info) !important; }

.text-theme-success { color: var(--color-success) !important; }
.text-theme-warning { color: var(--color-warning) !important; }
.text-theme-error { color: var(--color-error) !important; }
.text-theme-info { color: var(--color-info) !important; }

/* Gradient backgrounds */
.bg-gradient-theme-primary {
    background: linear-gradient(135deg, var(--color-primary) 0%, rgba({{ $primaryRgb['r'] }}, {{ $primaryRgb['g'] }}, {{ $primaryRgb['b'] }}, 0.8) 100%) !important;
}
</style>

<script>
// JavaScript function to update theme colors dynamically
window.updateThemeColors = function(colors) {
    const root = document.documentElement;
    
    if (colors.primary) root.style.setProperty('--color-primary', colors.primary);
    if (colors.primary_light) root.style.setProperty('--color-primary-light', colors.primary_light);
    if (colors.primary_dark) root.style.setProperty('--color-primary-dark', colors.primary_dark);
    if (colors.background_secondary) root.style.setProperty('--color-background-secondary', colors.background_secondary);
    if (colors.background_tertiary) root.style.setProperty('--color-background-tertiary', colors.background_tertiary);
    
    // Update opacity variants
    if (colors.primary) {
        const rgb = hexToRgb(colors.primary);
        const style = document.getElementById('dynamic-theme-colors');
        if (style) {
            let css = style.textContent;
            css = css.replace(/\.bg-theme-primary-5.*?;/g, `.bg-theme-primary-5 { background-color: rgba(${rgb.r}, ${rgb.g}, ${rgb.b}, 0.05) !important; }`);
            css = css.replace(/\.bg-theme-primary-10.*?;/g, `.bg-theme-primary-10 { background-color: rgba(${rgb.r}, ${rgb.g}, ${rgb.b}, 0.1) !important; }`);
            css = css.replace(/\.bg-theme-primary-20.*?;/g, `.bg-theme-primary-20 { background-color: rgba(${rgb.r}, ${rgb.g}, ${rgb.b}, 0.2) !important; }`);
            style.textContent = css;
        }
    }
};

// Helper function to convert hex to RGB
function hexToRgb(hex) {
    const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}
</script>




