@extends('layouts.base')

@section('title', 'Markets')

@section('content')
<body class="bg-[#0A0714] text-white">
    <!-- ========== NAVIGATION ========== -->
     @include('layouts.nav')
    <!-- ========== END NAVIGATION ========== -->

    <div class="pt-24 bg-theme-secondary min-h-screen">
        <!-- Page Hero -->
        <section class="container mx-auto px-4 py-16">
            <div class="text-center max-w-2xl mx-auto mb-12">
                <h1 class="text-3xl md:text-5xl font-bold mb-4">
                    Explore Our Markets
                </h1>
                <p class="text-gray-400">
                    Stay ahead of the curve with real-time data on top cryptocurrency markets.
                </p>
            </div>
        </section>

        <!-- Search/Filter Bar -->
        <section class="container mx-auto px-4 mb-8">
            <div
                class="bg-theme-tertiary border border-gray-800/50 rounded-xl p-4 flex flex-col md:flex-row items-center md:justify-between gap-4"
            >
                <div class="flex items-center gap-2 w-full md:w-auto">
                    <label for="search" class="sr-only">Search</label>
                    <div class="relative w-full md:w-64">
                        <input
                            type="text"
                            id="search"
                            placeholder="Search Markets..."
                            class="bg-theme-secondary text-gray-300 w-full rounded-xl py-2 px-4 focus:outline-none focus:ring-1 focus:ring-theme-primary"
                        />
                        <div
                            class="absolute right-4 top-1/2 transform -translate-y-1/2 text-gray-500"
                        >
                            <i class="fas fa-search"></i>
                        </div>
                    </div>
                </div>

                <!-- Example Filter Buttons (Static) -->
                <div class="flex items-center gap-2 flex-wrap">
                    <button
                        class="market-filter bg-theme-primary/10 text-theme-primary px-4 py-2 rounded-xl"
                        data-filter="All"
                    >
                        All
                    </button>
                    <button
                        class="market-filter bg-transparent border border-gray-800/50 text-gray-400 px-4 py-2 rounded-xl"
                        data-filter="BTC"
                    >
                        BTC
                    </button>
                    <button
                        class="market-filter bg-transparent border border-gray-800/50 text-gray-400 px-4 py-2 rounded-xl"
                        data-filter="ETH"
                    >
                        ETH
                    </button>
                    <button
                        class="market-filter bg-transparent border border-gray-800/50 text-gray-400 px-4 py-2 rounded-xl"
                        data-filter="BNB"
                    >
                        BNB
                    </button>
                </div>
            </div>
        </section>

        <!-- Markets Table -->
        <section class="container mx-auto px-4">
            <div
                class="overflow-x-auto bg-theme-tertiary border border-gray-800/50 rounded-xl"
            >
                <table class="min-w-full text-left">
                    <thead>
                        <tr class="border-b border-gray-800">
                            <th class="px-4 py-3 text-gray-400">Pair</th>
                            <th class="px-4 py-3 text-gray-400">Price</th>
                            <th class="px-4 py-3 text-gray-400">24h Change</th>
                            <th class="px-4 py-3 text-gray-400">24h High</th>
                            <th class="px-4 py-3 text-gray-400">24h Low</th>
                            <th class="px-4 py-3 text-gray-400">24h Volume</th>
                            <th class="px-4 py-3 text-gray-400">Action</th>
                        </tr>
                    </thead>
                    <tbody id="markets-table-body" class="divide-y divide-gray-800">
                        <!-- Dynamic rows inserted by JS -->
                    </tbody>
                </table>
            </div>

            <!-- Pagination Controls -->
            <div
                id="pagination"
                class="flex justify-center items-center gap-2 mt-6 mb-6"
            >
                <!-- Pagination buttons go here -->
            </div>
        </section>
  @include('layouts.includes.livechat')
         @include('layouts.foot')
    <!-- ========== END FOOTER ========== -->
@endsection





