<div class="space-y-6">
    {{-- Account Deletion Section --}}
    <div class="space-y-2">
        <h4 class="text-lg font-medium">{{ __('t.delete_acc') }}</h4>
        <p class="text-gray-400">{{ __('t.permanently_delete_your_account') }}</p>
        <p class="text-red-400 text-sm">
            {{ __('t.account_deletion_warning') }}
        </p>
    </div>

    <button 
        wire:click="confirmUserDeletion" 
        wire:loading.attr="disabled"
        class="bg-red-400/10 text-red-400 px-4 py-2 rounded-lg hover:bg-red-400/20 transition-colors">
        {{ __('t.delete_account') }}
    </button>

    <x-dialog-modal wire:model.live="confirmingUserDeletion">
        <x-slot name="title">
            {{ __('t.delete_account') }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <p class="text-gray-300">
                    {{ __('t.are_you_sure_delete_account') }}
                </p>

                <div x-data="{}" 
                    x-on:confirming-delete-user.window="setTimeout(() => $refs.password.focus(), 250)">
                    <input type="password"
                        wire:model="password"
                        x-ref="password"
                        wire:keydown.enter="deleteUser"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]"
                        placeholder="{{ __('t.password') }}"
                        autocomplete="current-password">
                    
                    <x-input-error for="password" class="mt-2" />
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <div class="flex justify-end gap-3">
                <button wire:click="$toggle('confirmingUserDeletion')"
                    class="px-4 py-2 rounded-lg border border-gray-700 text-gray-300 hover:text-gray-100 transition-colors">
                    {{ __('t.cancel') }}
                </button>

                <button wire:click="deleteUser"
                    class="bg-red-400/10 text-red-400 px-4 py-2 rounded-lg hover:bg-red-400/20 transition-colors">
                    {{ __('t.delete_acc') }}
                </button>
            </div>
        </x-slot>
    </x-dialog-modal>
</div>



