<div class="space-y-6">
    {{-- Two Factor Authentication Section --}}
    <div class="text-center space-y-2">
        <h4 class="text-lg font-medium">{{ __('t.2fa') }}</h4>
        <p class="text-gray-400">{{ __('t.add_additional_security') }}</p>
    </div>

    <div class="text-center space-y-2">
        @if($this->enabled)
            @if($showingConfirmation)
                <p class="text-lg">{{ __('t.finish_enabling_two_factor_authentication') }}</p>
            @endif
        @else
            <h5 class="text-lg font-medium">{{ __('t.not_enabled_two_factor_authentication') }}</h5>
            <p class="text-sm text-gray-400">
                {{ __('t.two_factor_auth_enabled_description') }}
            </p>
        @endif
    </div>

    @if($this->enabled)
        @if($showingQrCode)
            <div class="text-center space-y-4">
                <p class="text-gray-300">
                    @if($showingConfirmation)
                        {{ __('t.finish_two_factor_authentication_description') }}
                    @else
                        {{ __('t.two_factor_authentication_enabled_description') }}
                    @endif
                </p>

                {{-- QR Code --}}
                <div class="inline-block bg-white p-4 rounded-lg">
                    {!! $this->user->twoFactorQrCodeSvg() !!}
                </div>

                {{-- Setup Key --}}
                <div class="bg-gray-800/50 p-4 rounded-lg">
                    <p class="font-medium">{{ __('t.setup_key') }}: {{ decrypt($this->user->two_factor_secret) }}</p>
                </div>

                @if($showingConfirmation)
                    <div class="space-y-2">
                        <label class="text-sm text-gray-400">{{ __('t.code') }}</label>
                        <input type="text"
                            id="code"
                            name="code"
                            inputmode="numeric"
                            autofocus
                            autocomplete="one-time-code"
                            wire:model="code"
                            wire:keydown.enter="confirmTwoFactorAuthentication"
                            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                    </div>
                @endif
            </div>
        @endif

        @if($showingRecoveryCodes)
            <div class="space-y-4">
                <p class="text-gray-300">
                    {{ __('t.store_recovery_codes') }}
                </p>

                <div class="bg-gray-800/50 p-4 rounded-lg">
                    <div class="grid gap-2 text-mono text-sm text-center">
                        @foreach(json_decode(decrypt($this->user->two_factor_recovery_codes), true) as $code)
                            <div class="font-mono">{{ $code }}</div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
    @endif

    {{-- Action Buttons --}}
    <div class="flex gap-3 justify-center">
        @if(!$this->enabled)
            <x-confirms-password wire:then="enableTwoFactorAuthentication">
                <button type="button"
                    wire:loading.attr="disabled"
                    class="bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                    {{ __('t.enable') }}
                </button>
            </x-confirms-password>
        @else
            @if($showingRecoveryCodes)
                <x-confirms-password wire:then="regenerateRecoveryCodes">
                    <button type="button" 
                        class="bg-gray-800/50 text-gray-300 px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors">
                        {{ __('t.regenerate_recovery_codes') }}
                    </button>
                </x-confirms-password>
            @elseif($showingConfirmation)
                <x-confirms-password wire:then="confirmTwoFactorAuthentication">
                    <button type="button"
                        wire:loading.attr="disabled"
                        class="bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                        {{ __('t.confirm') }}
                    </button>
                </x-confirms-password>
            @else
                <x-confirms-password wire:then="showRecoveryCodes">
                    <button type="button" 
                        class="bg-gray-800/50 text-gray-300 px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors">
                        {{ __('t.show_recovery_codes') }}
                    </button>
                </x-confirms-password>
            @endif

            @if($showingConfirmation)
                <x-confirms-password wire:then="disableTwoFactorAuthentication">
                    <button type="button"
                        wire:loading.attr="disabled"
                        class="bg-gray-800/50 text-gray-300 px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors">
                        {{ __('t.cancel') }}
                    </button>
                </x-confirms-password>
            @else
                <x-confirms-password wire:then="disableTwoFactorAuthentication">
                    <button type="button"
                        wire:loading.attr="disabled"
                        class="bg-red-400/10 text-red-400 px-4 py-2 rounded-lg hover:bg-red-400/20 transition-colors">
                        {{ __('t.disable') }}
                    </button>
                </x-confirms-password>
            @endif
        @endif
    </div>
</div>

<script>
    lucide.createIcons();

    document.addEventListener('DOMContentLoaded', () => {
        window.addEventListener('refresh-profile', () => {
            location.reload();
        });
    });
</script>



