<div class="space-y-6 mt-2">
    {{-- Breadcrumbs 
    <div class="pl-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dashboard') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.deposit.make') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.deposit') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.make_payment') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    {{-- Main Content --}}
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Left Column: Payment Details --}}
        <div class="lg:col-span-2">
            <div class="bg-theme-secondary rounded-xl overflow-hidden">
                {{-- Header with Amount --}}
                <div class="p-6 border-b border-gray-800/50">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-medium">{{ __('t.deposit_details') }}</h3>
                        <a href="{{ route('user.deposit.make') }}" 
                            @if($settings->spa_mode) wire:navigate @endif
                            class="inline-flex items-center gap-1.5 text-sm text-red-500 hover:text-red-400">
                            <i class="fas fa-times w-4 h-4"></i>
                            {{ __('t.cancel') }}
                        </a>
                    </div>
                </div>

                {{-- Amount Display with Timer and Conversion --}}
<div class="p-6 bg-gradient-to-r from-theme-primary-10 to-transparent">
    <div class="flex items-center justify-between mb-4">
        <div>
            <span class="text-gray-400">{{ __('t.amount_to_pay') }}</span>
            <div class="flex flex-col mt-1">
                <span class="text-2xl font-medium text-theme-primary">
                    {{ Number::currency($amount, $settings->s_currency) }}
                </span>
                @if($method->methodtype === 'crypto')
                    <div class="mt-1">
                        @if($loading)
                            <div class="flex items-center gap-2 text-sm text-gray-400">
                                <i class="fas fa-spinner fa-spin"></i>
                                <span>{{ __('t.calculating') }}</span>
                            </div>
                        @elseif($error)
                            <button 
                                wire:click="refreshConversion"
                                class="text-sm text-red-400 hover:text-red-300 inline-flex items-center gap-2"
                            >
                                <span>{{ __('t.rate_error') }}</span>
                                <i class="fas fa-sync-alt"></i>
                            </button>
                        @else
                            <span class="text-sm text-gray-400">
                                ≈ {{ number_format($cryptoAmount, 8) }} {{ $method->name }}
                            </span>
                        @endif
                    </div>
                @endif
            </div>
        </div>
        
        {{-- Countdown Timer --}}
<div class="text-right"
    x-data="{ 
        timeLeft: 0,
        endTime: null,
        timerInterval: null,
        
        initTimer() {
            // Check if we have a stored end time
            const storedEndTime = sessionStorage.getItem('paymentEndTime');
            
            if (!storedEndTime) {
                // First time - set end time to 30 minutes from now
                this.endTime = Date.now() + (30 * 60 * 1000);
                sessionStorage.setItem('paymentEndTime', this.endTime);
            } else {
                this.endTime = parseInt(storedEndTime);
            }

            this.calculateTimeLeft();
            
            // Set up interval
            this.timerInterval = setInterval(() => {
                this.calculateTimeLeft();
                
                if (this.timeLeft <= 0) {
                    clearInterval(this.timerInterval);
                    $wire.refreshConversion();
                }
            }, 1000);
        },
        
        calculateTimeLeft() {
            const now = Date.now();
            const difference = this.endTime - now;
            
            // If timer has expired
            if (difference <= 0) {
                this.timeLeft = 0;
                sessionStorage.removeItem('paymentEndTime');
                return;
            }
            
            this.timeLeft = Math.floor(difference / 1000);
        },
        
        formatTime(seconds) {
            const mins = Math.floor(seconds / 60);
            const secs = seconds % 60;
            return `${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
        },
        
        // Cleanup on component destroy
        destroy() {
            if (this.timerInterval) {
                clearInterval(this.timerInterval);
            }
        }
    }"
    x-init="initTimer()"
    @if($method->methodtype === 'crypto')
        x-on:beforeunload.window="destroy()"
    @endif
>
    <div class="flex items-center gap-2 text-yellow-500">
        <i class="fas fa-clock"></i>
        <span class="font-medium" x-text="formatTime(timeLeft)">30:00</span>
    </div>
    <span class="text-xs text-gray-400">{{ __('t.time_remaining') }}</span>
</div>
    </div>
    </div>

                {{-- Payment Method Info --}}
                <div class="p-6 border-t border-gray-800/50">
                    <div class="flex items-center gap-4 mb-6">
                        <div class="w-12 h-12 flex items-center justify-center bg-gray-800/50 rounded-lg">
                            <img src="{{ $method->img_url }}" alt="{{ $method->name }}" class="w-8 h-8">
                        </div>
                        <div>
                            <h4 class="font-medium">{{ $method->name }}</h4>
                            <p class="text-sm text-gray-400">{{ __('t.network') }}: {{ strtoupper($method->name) }}</p>
                        </div>
                    </div>

                    {{-- Payment Method Content --}}
                    <div class="space-y-6">
                        @if($method->methodtype == 'crypto')
                            @include('millage.deposit.includes.crypto-payment')
                        @endif
                        @if($method->methodtype == 'currency')
                            @include('millage.deposit.includes.currency-payment')
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {{-- Right Column: Important Notes --}}
        <div class="lg:col-span-1 mb-10 md:mb-1">
            <div class="bg-theme-secondary rounded-xl p-6">
                <h3 class="text-lg font-medium mb-4">{{ __('t.important_notes') }}</h3>
                
                <div class="space-y-4">
                    {{-- Minimum Deposit --}}
                    <div class="flex items-start gap-3">
                        <div class="w-6 h-6 flex-shrink-0 flex items-center justify-center rounded-full bg-yellow-500/10">
                            <i class="fas fa-exclamation-triangle w-4 h-4 text-yellow-500"></i>
                        </div>
                        <div>
                            <h4 class="font-medium text-sm text-yellow-500">{{ __('t.min_deposit_title') }}</h4>
                            <p class="text-sm text-gray-400">{{ __('t.min_deposit_text') }}</p>
                        </div>
                    </div>

                    {{-- Network Confirmation --}}
                    <div class="flex items-start gap-3">
                        <div class="w-6 h-6 flex-shrink-0 flex items-center justify-center rounded-full bg-blue-500/10">
                            <i class="fas fa-info-circle w-4 h-4 text-blue-500"></i>
                        </div>
                        <div>
                            <h4 class="font-medium text-sm text-blue-500">{{ __('t.network_confirm_title') }}</h4>
                            <p class="text-sm text-gray-400">{{ __('t.network_confirm_text') }}</p>
                        </div>
                    </div>

                    {{-- Processing Time --}}
                    <div class="flex items-start gap-3">
                        <div class="w-6 h-6 flex-shrink-0 flex items-center justify-center rounded-full bg-green-500/10">
                            <i class="fas fa-clock w-4 h-4 text-green-500"></i>
                        </div>
                        <div>
                            <h4 class="font-medium text-sm text-green-500">{{ __('t.processing_time_title') }}</h4>
                            <p class="text-sm text-gray-400">{{ __('t.processing_time_text') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



