

<?php $__env->startSection('title', 'Trade History'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6 mt-4 md:mt-1 md:px-1 px-4 md:mb-1 mb-[40px]">
        
        <?php if($errors->any()): ?>
            <div class="bg-red-500 text-white p-4 rounded mb-4">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            
            <div class="bg-theme-secondary rounded-xl p-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm sm:text-base text-gray-400">Total Trades</p>
                        <p class="text-lg sm:text-xl font-medium mt-1"><?php echo e(number_format($summary['total_trades'])); ?></p>
                    </div>
                    <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-theme-primary/10">
                        <i class="fas fa-chart-bar text-theme-primary text-lg sm:text-base"></i>
                    </div>
                </div>
            </div>

            
            <div class="bg-theme-secondary rounded-xl p-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm sm:text-base text-gray-400">Total P/L</p>
                        <p class="text-lg sm:text-xl font-medium mt-1 <?php echo e($summary['total_profit'] >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                            <?php echo e($summary['total_profit'] >= 0 ? '+' : ''); ?>$<?php echo e(number_format($summary['total_profit'], 2)); ?>

                        </p>
                    </div>
                    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'w-10 h-10 flex items-center justify-center rounded-xl',
                        'bg-green-500/10' => $summary['total_profit'] >= 0,
                        'bg-red-500/10' => $summary['total_profit'] < 0,
                    ]); ?>">
                        <i class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                            'fas fa-dollar-sign text-lg sm:text-base',
                            'text-green-500' => $summary['total_profit'] >= 0,
                            'text-red-500' => $summary['total_profit'] < 0,
                        ]); ?>"></i>
                    </div>
                </div>
            </div>

            
            <div class="bg-theme-secondary rounded-xl p-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm sm:text-base text-gray-400">Wins</p>
                        <p class="text-lg sm:text-xl font-medium mt-1 text-green-500"><?php echo e(number_format($summary['win_count'])); ?></p>
                    </div>
                    <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-green-500/10">
                        <i class="fas fa-check text-green-500 text-lg sm:text-base"></i>
                    </div>
                </div>
            </div>

            
            <div class="bg-theme-secondary rounded-xl p-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm sm:text-base text-gray-400">Losses</p>
                        <p class="text-lg sm:text-xl font-medium mt-1 text-red-500"><?php echo e(number_format($summary['loss_count'])); ?></p>
                    </div>
                    <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-red-500/10">
                        <i class="fas fa-times text-red-500 text-lg sm:text-base"></i>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="bg-theme-secondary rounded-xl overflow-hidden">
            
            <div class="p-4 border-b border-gray-800/50">
                <form method="GET" action="<?php echo e(route('user.trading.history')); ?>" class="flex flex-col sm:flex-row sm:flex-wrap items-start sm:items-center gap-4">
                    
                    <div class="w-full sm:w-auto">
                        <label for="status" class="sr-only">Status</label>
                        <select name="status" id="status" class="w-full sm:w-auto bg-theme-tertiary border border-gray-800 rounded-lg px-3 py-2 text-sm text-gray-400 focus:outline-none focus:border-theme-primary">
                            <option value="">All Status</option>
                            <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                            <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                            <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>

                    
                    <div class="w-full sm:w-auto">
                        <label for="type" class="sr-only">Type</label>
                        <select name="type" id="type" class="w-full sm:w-auto bg-theme-tertiary border border-gray-800 rounded-lg px-3 py-2 text-sm text-gray-400 focus:outline-none focus:border-theme-primary">
                            <option value="">All Types</option>
                            <option value="Rise" <?php echo e(request('type') === 'Rise' ? 'selected' : ''); ?>>Rise</option>
                            <option value="Fall" <?php echo e(request('type') === 'Fall' ? 'selected' : ''); ?>>Fall</option>
                        </select>
                    </div>

                    
                    <div class="w-full sm:w-auto">
                        <label for="dateRange" class="sr-only">Date Range</label>
                        <input 
                            type="text" 
                            name="dateRange" 
                            id="dateRange" 
                            value="<?php echo e(request('dateRange')); ?>" 
                            class="w-full sm:w-auto bg-theme-tertiary border border-gray-800 rounded-lg px-3 py-2 text-sm text-gray-400 focus:outline-none focus:border-theme-primary"
                            placeholder="Date Range"
                            autocomplete="off"
                        >
                    </div>

                    
                    <div class="w-full sm:w-auto flex flex-col sm:flex-row sm:items-center gap-2">
                        <button 
                            type="submit"
                            class="w-full sm:w-auto px-3 py-2 bg-theme-primary rounded-lg text-sm text-black hover:bg-[#1ab8c1] transition-colors flex items-center justify-center gap-1"
                        >
                            <i class="fas fa-filter"></i>
                            <span>Apply</span>
                        </button>
                        <?php if(request('status') || request('type') || request('dateRange')): ?>
                            <a 
                                href="<?php echo e(route('user.trading.history')); ?>"
                                class="w-full sm:w-auto px-3 py-2 bg-gray-800/50 rounded-lg text-sm text-gray-400 hover:text-white transition-colors flex items-center justify-center gap-1"
                                aria-label="Reset Filters"
                            >
                                <i class="fas fa-sync-alt"></i>
                                <span>Reset</span>
                            </a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>

            
            <div class="overflow-x-auto">
                
                <table class="min-w-full divide-y divide-gray-800/50 hidden sm:table">
                    <thead class="bg-theme-tertiary">
                        <tr>
                            <th>
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'created_at', 'sort_direction' => request('sort_field') === 'created_at' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Time
                                    <?php if(request('sort_field') === 'created_at'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'type', 'sort_direction' => request('sort_field') === 'type' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Type
                                    <?php if(request('sort_field') === 'type'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'amount', 'sort_direction' => request('sort_field') === 'amount' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Amount
                                    <?php if(request('sort_field') === 'amount'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th class="hidden lg:table-cell">
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'entry_price', 'sort_direction' => request('sort_field') === 'entry_price' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Entry Price
                                    <?php if(request('sort_field') === 'entry_price'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'status', 'sort_direction' => request('sort_field') === 'status' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Status
                                    <?php if(request('sort_field') === 'status'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th class="hidden md:table-cell">
                                <a href="<?php echo e(route('user.trading.history', array_merge(request()->all(), ['sort_field' => 'profit_amount', 'sort_direction' => request('sort_field') === 'profit_amount' && request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>" class="px-6 py-3 text-left text-sm font-medium text-gray-400 cursor-pointer flex items-center gap-1">
                                    Profit/Loss
                                    <?php if(request('sort_field') === 'profit_amount'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?> w-4 h-4"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-800/50">
                        <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-800/30 transition-colors">
                                <td class="px-6 py-4 text-sm whitespace-nowrap">
                                    <?php echo e($trade->created_at->format('M d, Y H:i:s')); ?>

                                </td>
                                <td class="px-6 py-4">
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                        'px-2 py-1 rounded text-xs font-medium',
                                        'bg-green-500/10 text-green-500' => $trade->type === 'Rise',
                                        'bg-red-500/10 text-red-500' => $trade->type === 'Fall',
                                    ]); ?>">
                                        <?php echo e($trade->type); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm hidden md:table-cell">
                                    $<?php echo e(number_format($trade->amount, 2)); ?>

                                </td>
                                <td class="px-6 py-4 text-sm font-mono hidden lg:table-cell">
                                    $<?php echo e(number_format($trade->entry_price, 2)); ?>

                                </td>
                                <td class="px-6 py-4 text-sm">
                                    <?php if($trade->status === 'active'): ?>
                                        <div class="flex items-center gap-1.5 text-yellow-500">
                                            <i class="fas fa-circle-notch fa-spin text-xs"></i>
                                            <span>Active</span>
                                        </div>
                                    <?php elseif($trade->status === 'completed'): ?>
                                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'text-xs font-semibold',
                                            'text-green-500' => $trade->result === 'win',
                                            'text-red-500' => $trade->result === 'loss',
                                        ]); ?>">
                                            <?php echo e(ucfirst($trade->result)); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-gray-400"><?php echo e(ucfirst($trade->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 text-sm hidden md:table-cell">
                                    <?php if($trade->status === 'completed'): ?>
                                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'font-medium',
                                            'text-green-500' => $trade->profit_amount >= 0,
                                            'text-red-500' => $trade->profit_amount < 0,
                                        ]); ?>">
                                            <?php echo e($trade->profit_amount >= 0 ? '+' : ''); ?>$<?php echo e(number_format($trade->profit_amount, 2)); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-gray-400">--</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-400">
                                    <div class="flex flex-col items-center">
                                        <div class="w-16 h-16 mb-4 rounded-full bg-gray-800/50 flex items-center justify-center">
                                            <i class="fas fa-chart-line text-2xl"></i>
                                        </div>
                                        <p class="mb-2">No trades found</p>
                                        <p class="text-sm text-gray-500 mb-4">Try adjusting your filters or start trading</p>
                                        <div class="flex gap-4">
                                            <?php if(request('status') || request('type') || request('dateRange')): ?>
                                                <a 
                                                    href="<?php echo e(route('user.trading.history')); ?>"
                                                    class="text-theme-primary hover:underline text-sm flex items-center gap-1"
                                                    aria-label="Clear Filters"
                                                >
                                                    <i class="fas fa-sync-alt"></i>
                                                    Clear Filters
                                                </a>
                                            <?php endif; ?>
                                            <a 
                                                href="<?php echo e(route('user.trading.trade')); ?>"
                                                class="text-theme-primary hover:underline text-sm flex items-center gap-1"
                                                aria-label="Start Trading"
                                            >
                                                <i class="fas fa-play-circle"></i>
                                                Start Trading
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                
                <div class="sm:hidden">
                    <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="bg-theme-tertiary rounded-lg p-4 mb-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm sm:text-base text-gray-400">Time:</span>
                                <span class="text-sm sm:text-base"><?php echo e($trade->created_at->format('M d, Y H:i:s')); ?></span>
                            </div>
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm sm:text-base text-gray-400">Type:</span>
                                <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'px-2 py-1 rounded text-xs font-medium',
                                    'bg-green-500/10 text-green-500' => $trade->type === 'Rise',
                                    'bg-red-500/10 text-red-500' => $trade->type === 'Fall',
                                ]); ?>">
                                    <?php echo e($trade->type); ?>

                                </span>
                            </div>
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm sm:text-base text-gray-400">Amount:</span>
                                <span class="text-sm sm:text-base">$<?php echo e(number_format($trade->amount, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm sm:text-base text-gray-400">Entry Price:</span>
                                <span class="text-sm sm:text-base font-mono">$<?php echo e(number_format($trade->entry_price, 2)); ?></span>
                            </div>
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-sm sm:text-base text-gray-400">Status:</span>
                                <?php if($trade->status === 'active'): ?>
                                    <div class="flex items-center gap-1.5 text-yellow-500">
                                        <i class="fas fa-circle-notch fa-spin text-xs"></i>
                                        <span>Active</span>
                                    </div>
                                <?php elseif($trade->status === 'completed'): ?>
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                        'text-xs font-semibold',
                                        'text-green-500' => $trade->result === 'win',
                                        'text-red-500' => $trade->result === 'loss',
                                    ]); ?>">
                                        <?php echo e(ucfirst($trade->result)); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-gray-400"><?php echo e(ucfirst($trade->status)); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-sm sm:text-base text-gray-400">Profit/Loss:</span>
                                <?php if($trade->status === 'completed'): ?>
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                        'font-medium',
                                        'text-green-500' => $trade->profit_amount >= 0,
                                        'text-red-500' => $trade->profit_amount < 0,
                                    ]); ?>">
                                        <?php echo e($trade->profit_amount >= 0 ? '+' : ''); ?>$<?php echo e(number_format($trade->profit_amount, 2)); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-gray-400">--</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center text-gray-400 p-4">
                            <p>No trades found</p>
                            <a href="<?php echo e(route('user.trading.trade')); ?>" class="text-theme-primary hover:underline">Start Trading</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <?php if($trades->hasPages()): ?>
                <div class="px-6 py-3 border-t border-gray-800/50">
                    <?php echo e($trades->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize date range picker
            flatpickr("#dateRange", {
                mode: "range",
                dateFormat: "Y-m-d",
                theme: "dark",
                onChange: function(selectedDates, dateStr) {
                    // The input value is automatically updated by Flatpickr
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.millage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/millage/trading-page/history.blade.php ENDPATH**/ ?>